/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.beachparty.client.recipebook.group;

import com.google.common.collect.ImmutableList;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import satisfyu.beachparty.recipe.MiniFridgeRecipe;

@OnlyIn(value=Dist.CLIENT)
public enum MiniFridgeRecipeBookGroup implements IRecipeBookGroup
{
    SEARCH(new ItemStack((ItemLike)Items.f_42522_)),
    FRIDGE(new ItemStack((ItemLike)Blocks.f_50126_)),
    MISC(new ItemStack((ItemLike)Items.f_42452_));

    public static final List<IRecipeBookGroup> FRIDGE_GROUPS;
    private final List<ItemStack> icons;

    private MiniFridgeRecipeBookGroup(ItemStack ... entries) {
        this.icons = ImmutableList.copyOf((Object[])entries);
    }

    public boolean fitRecipe(Recipe<?> recipe) {
        if (recipe instanceof MiniFridgeRecipe) {
            MiniFridgeRecipe miniFridgeRecipe = (MiniFridgeRecipe)recipe;
            switch (this) {
                case SEARCH: {
                    return true;
                }
                case FRIDGE: {
                    if (!miniFridgeRecipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(Blocks.f_50126_.m_5456_().m_7968_()))) break;
                    return true;
                }
                case MISC: {
                    if (!miniFridgeRecipe.m_7527_().stream().noneMatch(ingredient -> ingredient.test(Blocks.f_50126_.m_5456_().m_7968_()))) break;
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        return false;
    }

    public List<ItemStack> getIcons() {
        return this.icons;
    }

    static {
        FRIDGE_GROUPS = ImmutableList.of((Object)((Object)SEARCH), (Object)((Object)FRIDGE), (Object)((Object)MISC));
    }
}

